<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Token_connection_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Guarda o actualiza un token en la tabla sma_certificador_tokens
     */
    public function guardar_token($conexion_id, $usuario, $token, $expiracion) {
        // Primero verificamos si ya existe un token para esa conexión
        $query = $this->db->get_where('sma_certificador_tokens', ['conexion_id' => $conexion_id]);

        if ($query && $query->num_rows() > 0) {
            // 🔄 Si existe, lo actualizamos
            $this->db->where('conexion_id', $conexion_id);
            return $this->db->update('sma_certificador_tokens', [
                'usuario'    => $usuario,
                'token'      => $token,
                'expiracion' => $expiracion,
                'updated_at' => date('Y-m-d H:i:s')
            ]);
        } else {
            // ➕ Si no existe, lo insertamos
            return $this->db->insert('sma_certificador_tokens', [
                'conexion_id' => $conexion_id,
                'usuario'     => $usuario,
                'token'       => $token,
                'expiracion'  => $expiracion,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ]);
        }
    }
}
